#include <iostream>
#include <vector>
#include <algorithm>
#include <stack>
#include <cmath>
using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int n;
    cin >> n;
    
    vector<pair<long long, int>> masts(n); // (x, index)
    vector<long long> heights(n);
    
    for (int i = 0; i < n; i++) {
        cin >> masts[i].first;
        masts[i].second = i;
    }
    
    for (int i = 0; i < n; i++) {
        cin >> heights[i];
    }
    
    // ????????? ??????? ?? x ??????????
    sort(masts.begin(), masts.end());
    
    vector<long long> x_sorted(n);
    vector<long long> h_sorted(n);
    vector<int> original_index(n);
    
    for (int i = 0; i < n; i++) {
        x_sorted[i] = masts[i].first;
        h_sorted[i] = heights[masts[i].second];
        original_index[i] = masts[i].second;
    }
    
    // ?????? ?? ?????????
    vector<long long> answer(n, -1);
    
    // ???????? ????? ?????? ??????? ??????? ?? ???? ??????? ???????
    // ????????? ???? ?? ????????? "????????" ???????
    stack<int> st;
    
    // ????????? ? ???? ?? ?????
    for (int i = 0; i < n; i++) {
        while (!st.empty()) {
            int j = st.top();
            
            // ??????????? ?? ?? ???????? ?????? ???? ?? ??????? ??????? j
            long long dist = x_sorted[i] - x_sorted[j];
            
            if (h_sorted[i] >= h_sorted[j] + dist) {
                // ???????? ?????? ?? ??????? ????? ?? ??????? j
                long long d = h_sorted[i] - h_sorted[j];
                if (answer[j] == -1 || d < answer[j]) {
                    answer[j] = d;
                }
                st.pop();
            } else if (h_sorted[j] >= h_sorted[i] + dist) {
                // ?????? j ?? ??????? ????? ?? ??????? ????????
                long long d = h_sorted[j] - h_sorted[i];
                if (answer[i] == -1 || d < answer[i]) {
                    answer[i] = d;
                }
                break;
            } else {
                // ??????????? ????? ?? ?????? ?????? j ? i
                // ??????? ?? ????? ??????? ??????
                long long xc = (h_sorted[j] + x_sorted[j] + x_sorted[i] - h_sorted[i]) / 2;
                
                // ?????? ?? ??? ?????
                long long yc = h_sorted[j] - (xc - x_sorted[j]);
                
                // ??????????? ?? ?? ?? ????? ??????? ?????? ?? j
                if (yc >= h_sorted[j]) {
                    long long d = (xc - x_sorted[j]) + (h_sorted[j] - yc);
                    if (answer[j] == -1 || d < answer[j]) {
                        answer[j] = d;
                    }
                }
                
                // ??????????? ?? ?? ?? ????? ??????? ?????? ?? i
                if (yc >= h_sorted[i]) {
                    long long d = (x_sorted[i] - xc) + (h_sorted[i] - yc);
                    if (answer[i] == -1 || d < answer[i]) {
                        answer[i] = d;
                    }
                }
                
                // ??? j ???? ???? ????????, ???????? ??
                if (h_sorted[i] >= h_sorted[j] - (x_sorted[i] - x_sorted[j])) {
                    st.pop();
                } else {
                    break;
                }
            }
        }
        st.push(i);
    }
    
    // ???????? ???? ?? ???? ?????? ? ????? ?? ????
    while (!st.empty()) st.pop();
    
    // ????????? ? ????? ?? ????
    for (int i = n - 1; i >= 0; i--) {
        while (!st.empty()) {
            int j = st.top();
            
            // ??????????? ?? ?? ???????? ?????? ???? ?? ??????? ??????? j
            long long dist = x_sorted[j] - x_sorted[i];
            
            if (h_sorted[i] >= h_sorted[j] + dist) {
                // ???????? ?????? ?? ??????? ????? ?? ??????? j
                long long d = h_sorted[i] - h_sorted[j];
                if (answer[j] == -1 || d < answer[j]) {
                    answer[j] = d;
                }
                st.pop();
            } else if (h_sorted[j] >= h_sorted[i] + dist) {
                // ?????? j ?? ??????? ????? ?? ??????? ????????
                long long d = h_sorted[j] - h_sorted[i];
                if (answer[i] == -1 || d < answer[i]) {
                    answer[i] = d;
                }
                break;
            } else {
                // ??????????? ????? ?? ?????? ?????? i ? j
                long long xc = (h_sorted[i] + x_sorted[i] + x_sorted[j] - h_sorted[j]) / 2;
                long long yc = h_sorted[i] - (xc - x_sorted[i]);
                
                // ??????????? ?? ?? ?? ????? ??????? ?????? ?? i
                if (yc >= h_sorted[i]) {
                    long long d = (xc - x_sorted[i]) + (h_sorted[i] - yc);
                    if (answer[i] == -1 || d < answer[i]) {
                        answer[i] = d;
                    }
                }
                
                // ??????????? ?? ?? ?? ????? ??????? ?????? ?? j
                if (yc >= h_sorted[j]) {
                    long long d = (x_sorted[j] - xc) + (h_sorted[j] - yc);
                    if (answer[j] == -1 || d < answer[j]) {
                        answer[j] = d;
                    }
                }
                
                // ??? j ???? ???? ????????, ???????? ??
                if (h_sorted[i] >= h_sorted[j] - (x_sorted[j] - x_sorted[i])) {
                    st.pop();
                } else {
                    break;
                }
            }
        }
        st.push(i);
    }
    
    // ????????? ???????? ? ?????????? ????????
    vector<long long> final_answer(n);
    for (int i = 0; i < n; i++) {
        final_answer[original_index[i]] = answer[i];
    }
    
    // ?????
    for (int i = 0; i < n; i++) {
        cout << final_answer[i] << "\n";
    }
    
    return 0;
}